//
//  WSHPHelper.h
//  WSCBSProductClient
//
//  Created by xiezh on 11-11-11.
//  Copyright 2011 wondershare. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "WSHPSuiteInfo.h"

@class WSHPHelperCommunicate;
@class CBSRegChecker;

//注册邮箱检测返回类型
typedef enum{
	//正常用户，正常提示注册成功
	crOK = 0,
	// 警告用户，在弹出注册成功提示之前弹出警告提示，警告提示后提示注册成功
	crWarning = 1,
	// 网络连接错误
	crError = 2,
	// 非法用户，清空注册信息，并弹出禁用提示，用户可以退出程序，也可继续注册
	crQuit = 3
}CBSRegCheckResult;

//提交检测的类型
typedef enum{
	// 启动时检测
	rcCheckOnStart = 0,
	// 注册时检测
	crCheckOnRegister = 1,
}CBSRegCheckType;

// 注册邮箱检测返回委托
@protocol CBSRegCheckerDelegate<NSObject>
- (void) RegCheckResult:(CBSRegCheckResult)result message:(NSString*)message;
@end

// 硬绑定产品下载完成通知主产品是否安装
@protocol BindAppDelegate <NSObject>
- (void)AskInstallTheBindApp:(NSString *)productBundleID productName:(NSString *)productName;
- (void)bindAppHasDownloadLength:(NSString *)length;
@end

// FTP文件上传进度查询
@protocol FTPUploadDelegate <NSObject>
- (void)fileUploadProcess:(NSString *)percent;
@end

@interface WSHPHelper : NSObject {
    @private
    NSTimer *autoStartTimer;
	WSHPHelperCommunicate * cmmt;
	CBSRegChecker* emailChecker;
	id<CBSRegCheckerDelegate> delegate;
}
+(id)share;
-(void)startHelper;
//产品退出时要调用此方法
-(void)stopHelper;

//广告：需要支持弹出广告的，在产品InfoPlist.strings文件中加上: "EnableAD" = "1";
//广告: 产品注册调用，
// 注意:1.老版本升级的情况，也需要调用
//     2.产品注册成功，传入email与注册码 
//     3.产品注册失败或被反注册了，传入email空数值
- (void)localRegisterEmail:(NSString* )email;

//启动的时候无论有没有注册，都要调用此方法，免费版的产品以及未注册产品邮箱传 nil或者空值
//防破解，异步注册邮箱检测，结果请实现CBSRegCheckerDelegate委托
- (bool) RegCheck:(NSString*)productID 
		  version:(NSString*)version 
			email:(NSString*)email 
		   langID:(NSString*)langID 
		checkType:(CBSRegCheckType)checkType;
//防破解，设置防破解返回委托
- (void) setRegCheckDelegate:(id <CBSRegCheckerDelegate>)aDelegate;
 

//下面两个方法用于内网的防破解验证：传YES为内网环境，传No则为外网环境
//用于防破解，是否是内网环境，默认是外网环境
- (void)setIsTestEnvionment:(BOOL)flag;
- (BOOL) isTestEnvironment;

#pragma mark 数据收集


//设置数据收集主PID，便于多语言产品的数据统计，没有设置的话，则默认用产品第一次启动的PID
- (void)setDataCollectPID:(NSString *)productID;

//第一种和第二种接口用于次数统计
//数据收集，通用自增加接口：用于target 和 key 都已经定义好的，对应于CBS后台的参数设置
- (void)commIncreaseDataCollect:(NSString *)target key:(NSString *)key;

//数据收集，后台自动生成的自增加接口：用于target或key需要在代码中自行定义的
- (void)autoCreatedIncreaseDataCollect:(NSString *)target key:(NSString *)key;

//数据收集，自定义字符串接口，用于字符串的收集
- (void)customStringDataCollect:(NSString *)target value:(NSString *)value;

//直接上传当前记录的数据
//若产品很长时间才使用一次，可在产品退出前主动调用此方法
- (void)directUploadData;

//开启或者禁用数据收集
//数据收集，设置某个产品数据收集的状态 设置为NO，则不收集数据
- (void)setProductCollectStatus:(BOOL)status;
- (BOOL)productCollectStatus;


#pragma mark Suite
//Suite : 产品推荐
//注册版本
- (WSHPSuiteInfo *) regSuiteInfo;
//试用版本
- (WSHPSuiteInfo *) unRegSuiteInfo;
//网络链接错误默认页面，也可自行设置链接
- (NSString *)netErrorPagePath;

#pragma mark Set TipsEnable
//启用或者禁用Tips消息推送
- (void)setTipsEnable:(BOOL)value;

#pragma mark bind Application
- (void) setBindAppInstallDelegate:(id <BindAppDelegate>)aDelegate;
- (void) installBindApplication:(BOOL)bInstall;

#pragma mark FTP upload
- (void)setFileUploadDelegate:(id <FTPUploadDelegate>)aDelegate;
- (void)FTPUploadFile:(NSString *)productID version:(NSString *)version filePah:(NSString *)filePath;

@end
